//-- TCPCLIENTDLG.CPP

#include "stdafx.h"
#include "TCPClient.h"
#include "TCPClientDlg.h"

/*************************************************************************************/
/********************  CLIENT DIALOG  ************************************************/
/*************************************************************************************/
BEGIN_MESSAGE_MAP(CTCPClientDlg, CDialog)
	//{{AFX_MSG_MAP(CTCPClientDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BN_QUIT, OnBnQuit)
	ON_BN_CLICKED(IDC_BN_SEND, OnBnSend)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CTCPClientDlg::CTCPClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTCPClientDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTCPClientDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CTCPClientDlg::~CTCPClientDlg()
{
	RemoveSockets();
}

void CTCPClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTCPClientDlg)
	DDX_Control(pDX, IDC_SERVERPORT, m_edServerPort);
	DDX_Control(pDX, IDC_SERVERNAME, m_edServerName);
	DDX_Control(pDX, IDC_MESSAGE, m_edMessage);
	DDX_Control(pDX, IDC_LOCALNAME, m_edLocalName);
	DDX_Control(pDX, IDC_LOCALIP, m_edLocalIP);
	//}}AFX_DATA_MAP
}

BOOL CTCPClientDlg::OnInitDialog()
{
	char		buf[255];

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
//-- Initialization
	InitSockets_1_1();
	m_edLocalName.SetWindowText(GetHostName(buf, 255));
	m_edLocalIP.SetWindowText(IPString(uGetLocalIP(), buf, 255));
	m_edMessage.SetWindowText("This is a TCP Message.");
	m_edServerPort.SetWindowText("4000");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTCPClientDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTCPClientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTCPClientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTCPClientDlg::OnBnQuit() 
{
	EndDialog(0);
}

void CTCPClientDlg::OnBnSend() 
{
	SOCKADDR_IN		addr_Dest;
	SOCKET			sock_Send;
	char			szMessage[256], szDestIP[20];;
	short			destport;
	CString			csTemp;

//-- Prepare the message
	m_edMessage.GetWindowText(csTemp);
	if (csTemp.IsEmpty())
	{
		AfxMessageBox("Please enter a message.");
		return;
	}
	sprintf(szMessage, csTemp.GetBuffer(0));
	csTemp.ReleaseBuffer(-1);
//-- Get the IP addres to send to
	m_edServerName.GetWindowText(csTemp);
	if (csTemp.IsEmpty())
	{
		AfxMessageBox("Please enter a valid host name or IP address");
		return;
	}
	strcpy(szDestIP, csTemp.GetBuffer(0));
	csTemp.ReleaseBuffer(-1);
//-- Get the port to send to
	m_edServerPort.GetWindowText(csTemp);
	destport = atoi(csTemp.GetBuffer(0));
	csTemp.ReleaseBuffer(-1);
	if (destport < 1)
	{
		AfxMessageBox("Please enter a valid TCP destination port");
		return;
	}

//-- Create TCP socket
	if ((sock_Send = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		AfxMessageBox("Error:  socket() failed.");

//-- Fill in target addr
	memset((char *) &addr_Dest, 0, sizeof(addr_Dest));
	addr_Dest.sin_family      = AF_INET;
	addr_Dest.sin_addr.s_addr = inet_addr(szDestIP);
	addr_Dest.sin_port        = htons(destport);             

//-- Connect to destination
	if (connect(sock_Send, (sockaddr*) &addr_Dest, sizeof(addr_Dest)) < 0)
		AfxMessageBox("Error:  connect() failed.");

//-- Send it
	if (send(sock_Send, szMessage, 256, 0) == SOCKET_ERROR)
		AfxMessageBox("Error:  send() failed.");

	closesocket(sock_Send);
}

/*********************************************************************************/
/***************  GENERAL WINSOCK  ***********************************************/
/*********************************************************************************/
int CTCPClientDlg::InitSockets_1_1() 
{
	WORD		wVersionRequested = MAKEWORD(1, 1);  
	WSADATA		wsaData; 
	int			res; 
 
	res = WSAStartup(wVersionRequested, &wsaData); 
//-- If WSAStartup fails, abort
	if (res != 0) 
		return 0; 
//-- Confirm that the Windows Sockets DLL supports 1.1.
//-- Although the DLL may support higher versions, wVersion will hold 1.1
//-- because that's the one we requested. 
	if (LOBYTE(wsaData.wVersion)!= 1 || HIBYTE(wsaData.wVersion)!= 1) 
	{ 
	//-- Version 1.1 is not supported, abort
		WSACleanup(); 
		return 0; 
	} 
//-- All's good
	return 1;
}

void CTCPClientDlg::RemoveSockets() 
{
	WSACleanup(); 
}

char* CTCPClientDlg::GetHostName(char* buf, int len) 
{
	if (gethostname(buf, len) == SOCKET_ERROR)
		return NULL;
	return buf;
}

unsigned int CTCPClientDlg::uGetLocalIP()
{
	char		szHostName[255];
	hostent*	HostData;
	
	GetHostName(szHostName, 255);
	HostData = gethostbyname(szHostName);
	if (HostData == NULL)
		return NULL;

	return *((unsigned int*)HostData->h_addr);
}

unsigned int CTCPClientDlg::uGetIPFromSockAddr_In(sockaddr_in* pSockAddr)
{
	return (unsigned int)pSockAddr->sin_addr.S_un.S_addr;
}

char* CTCPClientDlg::IPString(unsigned int addr, char* buf, int len)
{
	char* p = (char*)&addr;

	if (len < 16)
		return NULL;
	
	memset(buf, 0, len);
	sprintf(buf, "%d.%d.%d.%d", (unsigned char)*(p+0), (unsigned char)*(p+1), (unsigned char)*(p+2), (unsigned char)*(p+3));	

	return buf;
}

/*************************************************************************************/
/********************  ABOUT DIALOG  *************************************************/
/*************************************************************************************/
BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

